/*
 * Decompiled with CFR 0.152.
 */
package leens_nightmare;

import java.util.logging.Level;
import java.util.logging.Logger;
import leens_nightmare.Entity;
import leens_nightmare.MathTool;
import leens_nightmare.MoveRegister;
import leens_nightmare.Player;
import leens_nightmare.PlayerHandler;
import leens_nightmare.RandomTool;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.geom.Rectangle;
import org.newdawn.slick.state.StateBasedGame;

public class Zombie
extends Entity {
    private float angle;
    private float damage;
    private Player player;
    private float attackReload = 0.0f;
    private float difficulty;
    private float slowAmount;
    private float slowDuration = 750.0f;

    public Zombie(float xPos, float yPos, float difficulty) {
        super(xPos, yPos);
        try {
            this.texture = new Image("res/Zombie.png");
        }
        catch (SlickException ex) {
            Logger.getLogger(Zombie.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.bounds = new Rectangle(xPos, yPos, (float)this.texture.getWidth(), (float)this.texture.getHeight());
        this.difficulty = difficulty;
        this.speed = 0.08f;
        this.pathingX = 4.0f;
        this.pathingY = 25.0f;
        this.pathing = new Rectangle(xPos + this.pathingX, yPos + this.pathingY, 16.0f, 11.0f);
        this.player = PlayerHandler.getPlayer();
        this.baseScore = 10.0f * difficulty;
        this.damage = 1.5f * (difficulty / 10.0f + 1.0f);
        this.setMaxLife((float)(100 + RandomTool.getRandom().nextInt(76)) + difficulty * (float)(5 + RandomTool.getRandom().nextInt(6)));
        this.slowAmount = 0.25f + difficulty / 100.0f;
        this.moveStrat = MoveRegister.getFollow(this);
    }

    @Override
    public void update(GameContainer container, StateBasedGame game, int delta) {
        this.act(delta);
        super.update(container, game, delta);
    }

    @Override
    public void render(GameContainer container, StateBasedGame game, Graphics g) {
        super.render(container, game, g);
    }

    @Override
    public void act(int delta) {
        this.attackReload -= 0.5f * (float)delta;
        this.moveStrat.move(this, delta);
        if (MathTool.getDistanceToPlayer(this.xPos + (float)(this.texture.getWidth() / 2), this.yPos + (float)(this.texture.getHeight() / 2)) < 30.0f && this.attackReload <= 0.0f) {
            this.attack();
        }
    }

    public void attack() {
        this.player.setLife(this.player.getLife() - this.damage);
        this.player.slow(this.slowAmount, this.slowDuration);
        this.attackReload = 100.0f;
    }

    @Override
    public void enforceBorders(GameContainer container) {
    }
}

