/*
 * Decompiled with CFR 0.152.
 */
package leens_nightmare;

import java.util.logging.Level;
import java.util.logging.Logger;
import leens_nightmare.EnemyProjectileManager;
import leens_nightmare.Entity;
import leens_nightmare.MathTool;
import leens_nightmare.MoveRegister;
import leens_nightmare.RandomTool;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.geom.Rectangle;
import org.newdawn.slick.state.StateBasedGame;

public class SkeletonMage
extends Entity {
    private int moveCounter;
    private boolean recentlyFled;
    private float fireballReload = 0.0f;
    private int fireballsPerCast = 1;
    private int fireballCounter = 0;
    private float difficulty;

    public SkeletonMage(float xPos, float yPos, float difficulty) {
        super(xPos, yPos);
        try {
            this.texture = new Image("res/SkeletonMage.png");
        }
        catch (SlickException ex) {
            Logger.getLogger(SkeletonMage.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.bounds = new Rectangle(xPos, yPos, (float)this.texture.getWidth(), (float)this.texture.getHeight());
        this.difficulty = difficulty;
        this.setMaxLife((float)(40 + RandomTool.getRandom().nextInt(51)) + difficulty * (float)(2 + RandomTool.getRandom().nextInt(4)));
        this.speed = 0.08f;
        this.pathingX = 7.0f;
        this.pathingY = 36.0f;
        this.pathing = new Rectangle(xPos + this.pathingX, yPos + this.pathingY, 16.0f, 9.0f);
        this.baseScore = 15.0f * difficulty;
        this.fireballsPerCast = 1 + (int)(difficulty / 10.0f);
        this.moveStrat = MoveRegister.getCaster1(this);
    }

    @Override
    public void update(GameContainer container, StateBasedGame game, int delta) {
        this.act(delta);
        super.update(container, game, delta);
    }

    @Override
    public void act(int delta) {
        if (MathTool.getDistanceToPlayer(this.xPos + (float)(this.texture.getWidth() / 2), this.yPos + (float)(this.texture.getHeight() / 2)) < 100.0f && !this.recentlyFled) {
            this.moveStrat = MoveRegister.getFlee(this);
            this.moveCounter = 1;
            this.recentlyFled = true;
        }
        if (MathTool.getDistanceToLava(this) < 125.0f) {
            this.moveStrat = MoveRegister.getFleeLava(this);
            this.moveCounter = 1;
        }
        if (this.moveCounter >= 3800) {
            this.moveCounter = 0;
            this.recentlyFled = false;
        } else {
            if (this.moveCounter >= 1950) {
                if (!this.currentMoveStrat.equals("idle")) {
                    this.moveStrat = MoveRegister.getIdle(this);
                    this.fireballReload = 200.0f;
                }
                this.fireballReload -= 0.5f * (float)delta;
                if (this.fireballReload <= 0.0f) {
                    this.shootFireball(this.difficulty);
                }
            } else if (this.moveCounter == 0) {
                if (MathTool.getDistanceToPlayer(this.xPos + (float)(this.texture.getWidth() / 2), this.yPos + (float)(this.texture.getHeight() / 2)) > 300.0f) {
                    this.moveStrat = MoveRegister.getCasterTowards(this);
                    this.moveCounter = 500;
                } else {
                    this.moveStrat = MoveRegister.getCaster1(this);
                }
            }
            this.moveCounter += (RandomTool.getRandom().nextInt(2) + 1) * delta;
        }
        this.moveStrat.move(this, delta);
    }

    public void shootFireball(float difficulty) {
        int accuracy = (int)MathTool.getDistanceToPlayer(this.xPos, this.yPos) / 2;
        float x = RandomTool.getRandom().nextInt(accuracy) - (accuracy - 1) / 2;
        float y = RandomTool.getRandom().nextInt(accuracy) - (accuracy - 1) / 2;
        EnemyProjectileManager.SpawnProjectile(this.xPos, this.yPos, MathTool.getAngleToPlayer(this.xPos + x, this.yPos + y), MathTool.getAngleToPlayerInvY(this.xPos + x, this.yPos + y), 0, difficulty);
        ++this.fireballCounter;
        if (this.fireballCounter < this.fireballsPerCast) {
            this.fireballReload = 40.0f;
        } else {
            this.fireballReload = 400.0f;
            this.fireballCounter = 0;
        }
    }
}

