/*
 * Decompiled with CFR 0.152.
 */
package leens_nightmare;

import leens_nightmare.Entity;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.geom.Rectangle;
import org.newdawn.slick.geom.Shape;
import org.newdawn.slick.state.StateBasedGame;

public abstract class Projectile {
    float xPos;
    float yPos;
    Image texture;
    float speed;
    float angle;
    float lifeTime = 1.0f;
    Rectangle bounds;
    float damage;

    public Projectile(float xPos, float yPos, float angle, Image texture) {
        this.xPos = xPos;
        this.yPos = yPos;
        this.angle = angle;
        this.texture = texture;
        this.bounds = new Rectangle(xPos, yPos, (float)texture.getWidth(), (float)texture.getHeight());
    }

    public void render(GameContainer container, StateBasedGame game, Graphics g) {
        this.texture.draw(this.xPos, this.yPos);
    }

    public void update(GameContainer container, StateBasedGame game, int delta) {
        this.yPos += this.speed * (float)Math.cos(this.angle) * (float)delta;
        this.xPos += this.speed * (float)Math.sin(this.angle) * (float)delta;
        this.bounds.setLocation(this.xPos, this.yPos);
    }

    public boolean checkCollision(Shape shape) {
        return this.bounds.intersects(shape);
    }

    public void collision(Entity e) {
        if (this.lifeTime != 0.0f) {
            e.setLife(e.getLife() - this.damage);
            this.lifeTime = 0.0f;
        }
    }

    public void setXPos(float xPos) {
        this.xPos = xPos;
        this.bounds.setX(xPos);
    }

    public float getXPos() {
        return this.xPos;
    }

    public void setYPos(float yPos) {
        this.yPos = yPos;
        this.bounds.setY(yPos);
    }

    public float getYPos() {
        return this.yPos;
    }

    public float getLifeTime() {
        return this.lifeTime;
    }

    public void setLifeTime(float lifeTime) {
        this.lifeTime = lifeTime;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setBounds(Rectangle bounds) {
        this.bounds = bounds;
    }
}

