/*
 * Decompiled with CFR 0.152.
 */
package leens_nightmare;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import leens_nightmare.Entity;
import leens_nightmare.IceBall;
import leens_nightmare.IceParticle;
import leens_nightmare.LavaFlow;
import leens_nightmare.LavaSpray;
import leens_nightmare.Lightning;
import leens_nightmare.MathTool;
import leens_nightmare.Projectile;
import leens_nightmare.TileManager;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.Input;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.geom.Shape;
import org.newdawn.slick.state.StateBasedGame;

public class PlayerProjectileManager {
    private ArrayList<Projectile> projectiles;
    private ArrayList<IceParticle> iceParticles;
    private ArrayList<Entity> enemies;
    private final Image iceBall;
    private Iterator<Projectile> playeriterator;
    private Iterator<IceParticle> iceParticleiterator;
    private Iterator<Entity> enemyiterator;
    private LavaFlow lavaFlow;
    private final Image lavaSpray;
    private final Image lightning;
    private Input input;
    public static int iceParticleCreationCount;
    public static final int ICEBALL_ID = 0;
    public static float ICEBALL_MIDDLEX;
    public static float ICEBALL_MIDDLEY;
    public static final float ICEBALL_RELOAD = 200.0f;
    public static final int LAVASPRAY_ID = 1;
    public static final float LAVASPRAY_RELOAD = 3.0f;
    public static float LAVASPRAY_MIDDLEX;
    public static float LAVASPRAY_MIDDLEY;
    public static float LIGHTNING_MIDDLEX;
    public static final float LIGHTNING_RELOAD = 150.0f;

    public PlayerProjectileManager(ArrayList<Entity> enemies, LavaFlow lavaFlow) throws SlickException {
        this.enemies = enemies;
        this.projectiles = new ArrayList();
        this.iceParticles = new ArrayList();
        this.iceBall = new Image("res/ice.png");
        this.lavaSpray = new Image("res/LavaSpray.png");
        this.lightning = new Image("res/lightning.png");
        ICEBALL_MIDDLEX = this.iceBall.getWidth() / 2;
        LAVASPRAY_MIDDLEX = this.lavaSpray.getWidth() / 2 + 7;
        ICEBALL_MIDDLEY = this.iceBall.getHeight() / 2;
        LIGHTNING_MIDDLEX = this.lightning.getWidth() / 2;
        this.lavaFlow = lavaFlow;
    }

    public void SpawnProjectile(float xPos, float yPos, float angle, int id) {
        try {
            switch (id) {
                case 0: {
                    this.projectiles.add(new IceBall(xPos, yPos, angle, this.iceBall, this.iceParticles));
                    break;
                }
                case 1: {
                    this.projectiles.add(new LavaSpray(xPos + ICEBALL_MIDDLEX, yPos + ICEBALL_MIDDLEY, angle, this.lavaSpray));
                    break;
                }
                case 2: {
                    this.projectiles.add(new Lightning(xPos, yPos, angle, MathTool.getAngleInvX(this.input, LIGHTNING_MIDDLEX), new Image("res/lightning.png")));
                }
            }
        }
        catch (SlickException ex) {
            Logger.getLogger(PlayerProjectileManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void render(GameContainer container, StateBasedGame game, Graphics g) {
        for (Projectile projectile : this.projectiles) {
            projectile.render(container, game, g);
        }
        for (IceParticle iceParticle : this.iceParticles) {
            iceParticle.render(container, game, g);
        }
    }

    public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
        this.playeriterator = this.projectiles.iterator();
        iceParticleCreationCount += 1 * delta;
        while (this.playeriterator.hasNext()) {
            Projectile projectile = this.playeriterator.next();
            projectile.setYPos(projectile.getYPos() + TileManager.getScrollspeed() * (float)delta);
            projectile.update(container, game, delta);
            this.checkCollision(projectile);
            if (!(projectile.getYPos() < -100.0f || projectile.getYPos() > (float)(container.getHeight() + 100) || projectile.getXPos() < -100.0f || projectile.getXPos() > (float)(container.getWidth() + 100)) && !(projectile.getLifeTime() <= 0.0f)) continue;
            this.playeriterator.remove();
        }
        this.lavaCollision();
        if (iceParticleCreationCount > 15) {
            iceParticleCreationCount = 0;
        }
        for (IceParticle iceParticle : this.iceParticles) {
            iceParticle.update(container, game, delta);
            if (!(iceParticle.getLifeTime() <= 0.0f)) continue;
            this.iceParticleiterator.remove();
        }
        this.input = container.getInput();
    }

    public void addIceParticle(IceParticle i) {
        this.iceParticles.add(i);
    }

    public void lavaCollision() {
        this.checkCollision(this.lavaFlow);
    }

    public void checkCollision(Projectile p) {
        for (Entity e : this.enemies) {
            if (!p.checkCollision((Shape)e.getBounds())) continue;
            p.collision(e);
        }
    }

    public void reset(ArrayList<Entity> enemies) {
        this.enemies = enemies;
        this.projectiles = new ArrayList();
        this.iceParticles = new ArrayList();
    }
}

