/*
 * Decompiled with CFR 0.152.
 */
package leens_nightmare;

import leens_nightmare.Player;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.state.StateBasedGame;

public class PlayerHandler {
    public static Player player;
    private Image leenFace;
    private boolean dead = false;

    public PlayerHandler(Player player) {
        PlayerHandler.player = player;
    }

    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        this.leenFace = new Image("res/LeenFace.png");
    }

    public void render(GameContainer container, StateBasedGame game, Graphics g) {
        this.drawHealthBars(g);
        this.drawLeenFace(g);
    }

    public void update(GameContainer container, StateBasedGame game, int delta) {
        if (player.getLife() <= 0.0f) {
            this.dead = true;
        }
    }

    public void drawHealthBars(Graphics g) {
        g.setColor(Color.black);
        g.fillRect(200.0f, 550.0f, 400.0f, 30.0f);
        if (player.getLife() > 0.0f) {
            g.setColor(Color.red);
            g.fillRect(201.0f, 551.0f, 398.0f * (player.getLife() / player.getMaxLife()), 28.0f);
        }
        g.setColor(Color.white);
        if (player.getLife() > 0.0f) {
            g.drawString((int)player.getLife() + " / " + (int)player.getMaxLife(), 370.0f, 555.0f);
        } else {
            g.drawString("0 / " + (int)player.getMaxLife(), 370.0f, 555.0f);
        }
    }

    public void drawLeenFace(Graphics g) {
        this.leenFace.draw(110.0f, 527.0f);
    }

    public static Player getPlayer() {
        return player;
    }

    public boolean isDead() {
        return this.dead;
    }

    public void setDead(boolean dead) {
        this.dead = dead;
    }

    public void reset() {
        this.dead = false;
    }
}

