/*
 * Decompiled with CFR 0.152.
 */
package leens_nightmare;

import java.util.logging.Level;
import java.util.logging.Logger;
import leens_nightmare.Entity;
import leens_nightmare.MathTool;
import leens_nightmare.PlayerProjectileManager;
import leens_nightmare.TileManager;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.Input;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.geom.Rectangle;
import org.newdawn.slick.state.StateBasedGame;

public class Player
extends Entity {
    private PlayerProjectileManager projectiles;
    private Input input;
    private Image slowedTint;
    private float reloadTime;
    private final float doubleDirectionMultiplier = 0.707114f;
    private float originalSpeed;
    private boolean slowed = false;
    private float slowDuration;
    private float slowAmount = 0.0f;

    public Player(float xPos, float yPos, Image texture, PlayerProjectileManager projectiles) {
        super(xPos, yPos);
        try {
            this.texture = new Image("res/Player.png");
            this.slowedTint = new Image("res/PlayerSlowed.png");
        }
        catch (SlickException ex) {
            Logger.getLogger(Player.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.bounds = new Rectangle(xPos + 3.0f, yPos + 3.0f, (float)(texture.getWidth() - 6), (float)(texture.getHeight() - 6));
        this.projectiles = projectiles;
        this.slowedTint.setAlpha(0.5f);
        this.speed = 0.1f;
        this.pathingX = 2.0f;
        this.pathingY = 10.0f;
        this.pathing = new Rectangle(xPos + this.pathingX, yPos + this.pathingY, 8.0f, 10.0f);
        this.originalSpeed = this.speed;
        this.setMaxLife(500.0f);
    }

    @Override
    public void render(GameContainer container, StateBasedGame game, Graphics g) {
        super.render(container, game, g);
        if (this.slowed) {
            this.slowedTint.draw(this.xPos, this.yPos);
        }
    }

    @Override
    public void update(GameContainer container, StateBasedGame game, int delta) {
        if (this.slowed) {
            this.slowDuration -= 0.5f * (float)delta;
            if (this.slowDuration <= 0.0f) {
                this.slowAmount = 0.0f;
                this.slowed = false;
            }
        }
        if (this.reloadTime >= -9.0f) {
            this.reloadTime -= 0.5f * (float)delta;
        }
        TileManager.setScrollspeed(0.0f);
        this.reactToInput(container, delta);
        super.update(container, game, delta);
    }

    private void reactToInput(GameContainer container, int delta) {
        this.input = container.getInput();
        this.speed = (this.input.isKeyDown(31) && this.input.isKeyDown(32) || this.input.isKeyDown(31) && this.input.isKeyDown(30) || this.input.isKeyDown(17) && this.input.isKeyDown(32) || this.input.isKeyDown(17) && this.input.isKeyDown(30)) && (!this.input.isKeyDown(31) || !this.input.isKeyDown(17)) && (!this.input.isKeyDown(30) || !this.input.isKeyDown(32)) ? 0.707114f * this.originalSpeed * (1.0f - this.slowAmount) : this.originalSpeed * (1.0f - this.slowAmount);
        if (this.input.isKeyDown(31)) {
            TileManager.setScrollspeed(this.speed * -1.0f);
        }
        if (this.input.isKeyDown(17)) {
            TileManager.setScrollspeed(this.speed);
        }
        if (this.input.isKeyDown(32)) {
            this.xPos += this.speed * (float)delta;
        }
        if (this.input.isKeyDown(30)) {
            this.xPos -= this.speed * (float)delta;
        }
        if (this.input.isKeyDown(57)) {
            if (this.reloadTime <= 0.0f) {
                this.projectiles.SpawnProjectile(this.xPos, this.yPos, MathTool.getAngle(this.input, PlayerProjectileManager.ICEBALL_MIDDLEX), 0);
                this.reloadTime = 200.0f;
            }
        } else if (this.input.isMouseButtonDown(1)) {
            if (this.reloadTime <= 0.0f) {
                this.projectiles.SpawnProjectile(this.xPos, this.yPos, MathTool.getAngle(this.input, PlayerProjectileManager.LIGHTNING_MIDDLEX), 2);
                this.reloadTime = 150.0f;
            }
        } else if (this.input.isMouseButtonDown(0)) {
            while (this.reloadTime <= 0.0f) {
                this.projectiles.SpawnProjectile(this.xPos, this.yPos, MathTool.getAngle(this.input, PlayerProjectileManager.LAVASPRAY_MIDDLEX), 1);
                this.reloadTime += 3.0f;
            }
        }
    }

    @Override
    public void updateBounds() {
        this.bounds.setLocation(this.xPos + 3.0f, this.yPos + 3.0f);
    }

    public void slow(float amount, float duration) {
        this.slowed = true;
        this.slowAmount = amount;
        this.slowDuration = duration;
    }

    public void reset() {
        this.setxPos(400.0f);
        this.setyPos(300.0f);
        this.setLife(500.0f);
        this.reloadTime = 400.0f;
        this.slowAmount = 0.0f;
        this.slowed = false;
        this.slowDuration = 0.0f;
    }
}

