/*
 * Decompiled with CFR 0.152.
 */
package leens_nightmare;

import java.util.ArrayList;
import leens_nightmare.EnemyCreator;
import leens_nightmare.EnemyManager;
import leens_nightmare.EnemyProjectileManager;
import leens_nightmare.Entity;
import leens_nightmare.IceParticle;
import leens_nightmare.LavaFlow;
import leens_nightmare.LevelCreator;
import leens_nightmare.LevelRenderer;
import leens_nightmare.MathTool;
import leens_nightmare.MoveRegister;
import leens_nightmare.Player;
import leens_nightmare.PlayerHandler;
import leens_nightmare.PlayerProjectileManager;
import leens_nightmare.Projectile;
import leens_nightmare.ScoreManager;
import leens_nightmare.TileManager;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.Input;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;

public class MainMenu
extends BasicGameState {
    private int id;
    private Image playerImg;
    private ArrayList<IceParticle> particleEffects;
    private Player player;
    private PlayerHandler playerHandler;
    private ArrayList<Projectile> projectiles;
    private PlayerProjectileManager playerProjectileManager;
    private EnemyProjectileManager enemyProjectileManager;
    private ArrayList<Entity> enemies;
    private EnemyManager enemyManager;
    private MathTool angleCalc;
    private TileManager tileM;
    private LevelRenderer level;
    private MoveRegister moveRegister;
    private Input input;
    private float mouseX = 0.0f;
    private float mouseY = 0.0f;
    private float oldMouseX = 0.0f;
    private float oldMouseY = 0.0f;
    private float particleCount = 0.0f;
    private LevelCreator lvlCreator;
    private EnemyCreator enemyCreator;
    private LavaFlow lavaFlow;
    private boolean paused = false;
    private ScoreManager scoreManager;
    private Image deathTint;
    private float deathDelay = 100.0f;
    private boolean showDeath = false;
    private boolean resetReady = false;

    public MainMenu(int id) {
        this.id = id;
    }

    public int getID() {
        return this.id;
    }

    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        this.playerImg = new Image("res/Player.png");
        this.scoreManager = new ScoreManager();
        this.enemies = new ArrayList();
        this.enemyCreator = new EnemyCreator();
        this.enemyCreator.init(container, game);
        this.enemyManager = new EnemyManager(this.enemies, this.enemyCreator, this.scoreManager);
        this.lavaFlow = new LavaFlow(-20.0f, 600.0f, 0.0f, new Image("res/LavaFlow.png"));
        this.playerProjectileManager = new PlayerProjectileManager(this.enemies, this.lavaFlow);
        this.player = new Player(400.0f, 300.0f, this.playerImg, this.playerProjectileManager);
        this.playerHandler = new PlayerHandler(this.player);
        this.playerHandler.init(container, game);
        this.enemyProjectileManager = new EnemyProjectileManager(this.player, this.lavaFlow);
        this.angleCalc = new MathTool(this.player, this.lavaFlow);
        this.tileM = new TileManager();
        this.tileM.init(container, game);
        this.lvlCreator = new LevelCreator();
        this.level = new LevelRenderer(this.tileM, this.lvlCreator, this.enemyManager);
        this.level.init(container, game);
        this.moveRegister = new MoveRegister();
        this.moveRegister.init(container, game);
        this.deathTint = new Image("res/BlackBox.png");
        this.deathTint.setAlpha(0.65f);
    }

    public void render(GameContainer container, StateBasedGame game, Graphics g) throws SlickException {
        this.level.render(container, game, g);
        this.player.render(container, game, g);
        this.playerProjectileManager.render(container, game, g);
        this.enemyManager.render(container, game, g);
        this.enemyProjectileManager.render(container, game, g);
        this.lavaFlow.render(container, game, g);
        this.playerHandler.render(container, game, g);
        this.scoreManager.render(container, game, g);
        if (this.paused) {
            this.deathTint.draw(-1.0f, -1.0f);
            g.setColor(Color.white);
            g.drawString("Paused", 375.0f, 250.0f);
        }
        if (this.showDeath) {
            this.deathTint.draw(-1.0f, -1.0f);
            g.setColor(Color.red);
            g.drawString("You are dead", 335.0f, 250.0f);
            g.setColor(Color.white);
            g.drawString("Final score: " + (int)this.scoreManager.getCurrentScore(), 325.0f, 300.0f);
            if (this.resetReady) {
                g.drawString("Press ", 300.0f, 350.0f);
                g.setColor(Color.red);
                g.drawString("space", 350.0f, 350.0f);
                g.setColor(Color.white);
                g.drawString("to try again", 400.0f, 350.0f);
            }
        }
    }

    public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
        if (!this.paused && !this.playerHandler.isDead()) {
            this.level.update(container, game, delta);
            this.player.update(container, game, delta);
            this.playerProjectileManager.update(container, game, delta);
            this.enemyManager.update(container, game, delta);
            this.enemyProjectileManager.update(container, game, delta);
            this.lavaFlow.update(container, game, delta);
            this.playerHandler.update(container, game, delta);
            this.particleCount += (float)(1 * delta);
        }
        this.input = container.getInput();
        if (this.playerHandler.isDead()) {
            if (!this.showDeath) {
                this.deathDelay -= 0.1f * (float)delta;
                if (this.deathDelay <= 0.0f) {
                    this.showDeath = true;
                    this.deathDelay = 100.0f;
                }
            } else if (!this.resetReady) {
                this.deathDelay -= 0.1f * (float)delta;
                if (this.deathDelay <= 0.0f) {
                    this.resetReady = true;
                    this.deathDelay = 100.0f;
                    this.input.clearKeyPressedRecord();
                }
            }
        }
        if (this.resetReady && this.input.isKeyPressed(57)) {
            this.reset();
        }
        if (this.input.isMousePressed(1)) {
            // empty if block
        }
        if (this.input.isMousePressed(2)) {
            this.reset();
        }
        if ((this.input.isKeyPressed(25) || this.input.isKeyPressed(1)) && !this.playerHandler.isDead()) {
            this.paused = !this.paused;
        }
    }

    public void reset() {
        this.enemies = new ArrayList();
        this.enemyManager.reset(this.enemies);
        this.enemyProjectileManager.reset();
        this.lavaFlow.reset();
        this.player.reset();
        this.playerHandler.reset();
        this.playerProjectileManager.reset(this.enemies);
        this.scoreManager.reset();
        this.level.reset();
        this.showDeath = false;
        this.resetReady = false;
    }
}

