/*
 * Decompiled with CFR 0.152.
 */
package leens_nightmare;

import java.util.ArrayList;
import leens_nightmare.Entity;
import leens_nightmare.Projectile;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.state.StateBasedGame;

public class Lightning
extends Projectile {
    private ArrayList<Entity> hitList;

    public Lightning(float xPos, float yPos, float angle, float angleInvX, Image texture) {
        super(xPos, yPos, angle, texture);
        this.bounds.setLocation(this.xPos + 76.0f * (float)Math.sin(angle), this.yPos + 76.0f * (float)Math.cos(angle));
        this.bounds.setSize((float)this.texture.getWidth(), (float)this.texture.getWidth());
        this.damage = 25.0f;
        this.texture.setCenterOfRotation(9.5f, 0.0f);
        this.speed = 0.8f;
        this.texture.setRotation((float)Math.toDegrees(angleInvX));
        this.hitList = new ArrayList();
    }

    @Override
    public void update(GameContainer container, StateBasedGame game, int delta) {
        super.update(container, game, delta);
    }

    @Override
    public void render(GameContainer container, StateBasedGame game, Graphics g) {
        super.render(container, game, g);
    }

    @Override
    public void setYPos(float yPos) {
        this.yPos = yPos;
        this.bounds.setY(yPos + 76.0f * (float)Math.cos(this.angle));
    }

    @Override
    public void collision(Entity e) {
        boolean isHit = false;
        for (Entity e2 : this.hitList) {
            if (!e.equals(e2)) continue;
            isHit = true;
        }
        if (!isHit) {
            e.setLife(e.getLife() - this.damage);
            this.hitList.add(e);
        }
    }
}

