/*
 * Decompiled with CFR 0.152.
 */
package leens_nightmare;

import java.util.LinkedList;
import leens_nightmare.EnemyManager;
import leens_nightmare.LevelCreator;
import leens_nightmare.TileManager;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.state.StateBasedGame;

public class LevelRenderer {
    private TileManager t;
    int[] i = null;
    private int[][] defaultMap;
    private float scroll;
    private Image ground;
    private int groundId;
    private Image ground2;
    private int ground2Id;
    private Image ground3;
    private int ground3Id;
    private int tileSize;
    private float scrollspeed;
    private float mapPos = 0.0f;
    private LinkedList<int[]> map;
    private int tileMover;
    private LevelCreator lvlCreator;
    private int extraRows;
    private EnemyManager enemyManager;
    private int currentLvl;
    private float difficulty = 1.0f;

    public LevelRenderer(TileManager t, LevelCreator lvlCreator, EnemyManager enemyManager) {
        this.lvlCreator = lvlCreator;
        this.enemyManager = enemyManager;
        this.t = t;
    }

    public void init(GameContainer container, StateBasedGame game) {
        this.ground2 = this.t.getGround2();
        this.ground = this.t.getGround();
        this.groundId = this.t.getGroundId();
        this.ground2Id = this.t.getGround2Id();
        this.ground3 = this.t.getGround3();
        this.ground3Id = this.t.getGround3Id();
        this.tileSize = this.t.getTileSize();
        LevelRenderer levelRenderer = this;
        this.tileMover = levelRenderer.t.getTileMover();
        LevelRenderer levelRenderer2 = this;
        this.scrollspeed = levelRenderer2.t.getScrollspeed();
        this.defaultMap = this.lvlCreator.getDefaultMap();
        this.currentLvl = 1;
        this.map = new LinkedList();
        for (int[] i : this.defaultMap) {
            this.map.add(i);
        }
    }

    public void render(GameContainer container, StateBasedGame game, Graphics g) throws SlickException {
        for (int y = 0; y < this.map.size(); ++y) {
            if (!((float)(y * this.tileSize) + this.scroll - (float)(this.extraRows * this.tileSize) < (float)(container.getHeight() - this.tileMover)) || !((float)(y * this.tileSize) + this.scroll - (float)(this.extraRows * this.tileSize) > (float)(0 + this.tileMover))) continue;
            for (int x = 0; x < this.map.get(y).length; ++x) {
                if (this.map.get(y)[x] == this.groundId) {
                    this.ground.draw((float)(x * this.tileSize), (float)(y * this.tileSize) + this.scroll + (float)this.tileMover - (float)(this.extraRows * this.tileSize));
                    continue;
                }
                if (this.map.get(y)[x] == this.ground2Id) {
                    this.ground2.draw((float)(x * this.tileSize), (float)(y * this.tileSize) + this.scroll + (float)this.tileMover - (float)(this.extraRows * this.tileSize));
                    continue;
                }
                if (this.map.get(y)[x] != this.ground3Id) continue;
                this.ground3.draw((float)(x * this.tileSize), (float)(y * this.tileSize) + this.scroll + (float)this.tileMover - (float)(this.extraRows * this.tileSize));
            }
        }
    }

    public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
        LevelRenderer levelRenderer = this;
        this.scrollspeed = levelRenderer.t.getScrollspeed();
        this.scroll += this.scrollspeed * (float)delta;
        if (this.scroll >= (float)this.tileSize) {
            if (this.extraRows == 0) {
                for (int[] i : this.lvlCreator.createLevel()) {
                    this.map.addFirst(i);
                    this.mapPos += 32.0f;
                    ++this.extraRows;
                }
            }
            this.scroll = 0.0f;
            --this.extraRows;
            this.difficulty += 0.1f;
            this.enemyManager.spawnEnemies(this.currentLvl, this.difficulty);
        }
        if (this.scroll <= (float)(this.tileSize * -1)) {
            // empty if block
        }
    }

    public void reset() {
        this.map = new LinkedList();
        for (int[] i : this.defaultMap) {
            this.map.add(i);
        }
        this.extraRows = 0;
        this.mapPos = 0.0f;
        this.scroll = 0.0f;
        this.difficulty = 1.0f;
    }
}

