/*
 * Decompiled with CFR 0.152.
 */
package leens_nightmare;

import leens_nightmare.Entity;
import leens_nightmare.Projectile;
import leens_nightmare.TileManager;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.state.StateBasedGame;

public class LavaFlow
extends Projectile {
    private int delta;

    public LavaFlow(float xPos, float yPos, float angle, Image texture) {
        super(xPos, yPos, angle, texture);
        this.damage = 0.25f;
        this.lifeTime = 1.0f;
        this.speed = 0.04f;
    }

    public void init(GameContainer container, StateBasedGame game) throws SlickException {
    }

    @Override
    public void render(GameContainer container, StateBasedGame game, Graphics g) {
        if (this.yPos < 650.0f) {
            this.texture.draw(this.xPos, this.yPos);
        }
    }

    @Override
    public void update(GameContainer container, StateBasedGame game, int delta) {
        this.yPos -= (this.speed - TileManager.getScrollspeed()) * (float)delta;
        this.bounds.setLocation(this.xPos, this.yPos);
        this.delta = delta;
    }

    @Override
    public void collision(Entity e) {
        e.setLife(e.getLife() - this.damage * (float)this.delta);
    }

    public void reset() {
        super.setXPos(-20.0f);
        super.setYPos(600.0f);
    }
}

