/*
 * Decompiled with CFR 0.152.
 */
package leens_nightmare;

import leens_nightmare.Projectile;
import leens_nightmare.TileManager;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.state.StateBasedGame;

public class IceParticle
extends Projectile {
    private float alpha = 0.5f;
    private float rotation;

    public IceParticle(float xPos, float yPos, Image texture, int initRotation, float rotation) {
        super(xPos, yPos, 0.0f, texture);
        texture.setRotation((float)initRotation);
        this.rotation = rotation;
        texture.setAlpha(this.alpha);
        this.lifeTime = 750.0f;
    }

    @Override
    public void render(GameContainer container, StateBasedGame game, Graphics g) {
        this.texture.draw(this.xPos, this.yPos, 0.5f);
    }

    @Override
    public void update(GameContainer container, StateBasedGame game, int delta) {
        this.texture.rotate(this.rotation * (float)delta);
        this.lifeTime -= (float)(1 * delta);
        this.yPos += TileManager.getScrollspeed() * (float)delta;
        if (this.lifeTime <= 520.0f) {
            this.alpha = (float)((double)this.alpha - 0.001 * (double)delta);
            this.texture.setAlpha(this.alpha);
        }
    }
}

