/*
 * Decompiled with CFR 0.152.
 */
package leens_nightmare;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import leens_nightmare.EnemyManager;
import leens_nightmare.Entity;
import leens_nightmare.IceParticle;
import leens_nightmare.MathTool;
import leens_nightmare.PlayerProjectileManager;
import leens_nightmare.Projectile;
import leens_nightmare.RandomTool;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.state.StateBasedGame;

public class IceBall
extends Projectile {
    private final ArrayList<IceParticle> particleEffects;
    private float explosionX;
    private float explosionY;

    public IceBall(float xPos, float yPos, float angle, Image texture, ArrayList<IceParticle> particleEffects) {
        super(xPos, yPos, angle, texture);
        this.particleEffects = particleEffects;
        this.speed = 0.2f;
        this.damage = 50.0f;
    }

    @Override
    public void update(GameContainer container, StateBasedGame game, int delta) {
        super.update(container, game, delta);
        this.texture.rotate((float)(1 * delta));
        try {
            if (PlayerProjectileManager.iceParticleCreationCount > 15) {
                this.particleEffects.add(new IceParticle(this.xPos, this.yPos, new Image("res/ice.png"), RandomTool.getRandom().nextInt(360), RandomTool.getRandom().nextFloat() / 2.0f - 0.25f));
            }
        }
        catch (SlickException slickException) {
            // empty catch block
        }
    }

    @Override
    public void collision(Entity e) {
        super.collision(e);
        EnemyManager.areaDamage(e, 50.0f, 30.0f);
        this.explode(e);
    }

    public void explode(Entity e) {
        for (int i = 0; i < 50; ++i) {
            try {
                do {
                    this.explosionX = e.getxPos() + (float)(e.texture.getWidth() / 2) + (float)RandomTool.getRandom().nextInt(101) - 50.0f;
                    this.explosionY = e.getyPos() + (float)(e.texture.getHeight() / 2) + (float)RandomTool.getRandom().nextInt(101) - 50.0f;
                } while (MathTool.getDistanceBetweenPoints(e.getxPos() + (float)(e.texture.getWidth() / 2), e.getyPos() + (float)(e.texture.getHeight() / 2), this.explosionX, this.explosionY) > 50.0f);
                this.particleEffects.add(new IceParticle(this.explosionX, this.explosionY, new Image("res/ice.png"), 0, RandomTool.getRandom().nextFloat() / 2.0f - 0.25f));
                continue;
            }
            catch (SlickException ex) {
                Logger.getLogger(IceBall.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

