/*
 * Decompiled with CFR 0.152.
 */
package leens_nightmare;

import leens_nightmare.MoveStrategy;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.geom.Rectangle;
import org.newdawn.slick.geom.Shape;
import org.newdawn.slick.state.StateBasedGame;

public abstract class Entity {
    float xPos;
    float yPos;
    Image texture;
    Rectangle bounds;
    float life;
    float maxLife;
    float speed;
    Rectangle pathing;
    float pathingX;
    float pathingY;
    MoveStrategy moveStrat;
    String currentMoveStrat;
    float baseScore;

    public Entity(float xPos, float yPos) {
        this.xPos = xPos;
        this.yPos = yPos;
    }

    public void render(GameContainer container, StateBasedGame game, Graphics g) {
        this.texture.draw(this.xPos, this.yPos);
    }

    public void update(GameContainer container, StateBasedGame game, int delta) {
        this.enforceBorders(container);
        this.updateBounds();
        this.pathing.setLocation(this.xPos + this.pathingX, this.yPos + this.pathingY);
    }

    public void pathing(Rectangle r) {
        if (this.pathing.intersects((Shape)r) && !this.pathing.equals(r)) {
            if (this.pathing.getMaxY() - r.getMinY() < 4.0f) {
                this.setyPos(this.getyPos() - (this.pathing.getMaxY() - r.getMinY()));
            }
            if (this.pathing.getMaxY() - r.getMinY() > 18.0f) {
                this.setyPos(this.getyPos() + (r.getMaxY() - this.pathing.getMinY()));
            }
            if (this.pathing.getMaxX() - r.getMinX() < 4.0f) {
                this.setxPos(this.getxPos() - (this.pathing.getMaxX() - r.getMinX()));
            }
            if (this.pathing.getMaxX() - r.getMinX() > 28.0f) {
                this.setxPos(this.getxPos() + (r.getMaxX() - this.pathing.getMinX()));
            }
        }
    }

    public void act(int delta) {
    }

    public float getLife() {
        return this.life;
    }

    public void setLife(float life) {
        this.life = life;
    }

    public void setMaxLife(float life) {
        this.life = life;
        this.maxLife = life;
    }

    public float getxPos() {
        return this.xPos;
    }

    public void setxPos(float xPos) {
        this.xPos = xPos;
        this.updateBounds();
        this.pathing.setX(xPos + this.pathingX);
    }

    public float getyPos() {
        return this.yPos;
    }

    public void setyPos(float yPos) {
        this.yPos = yPos;
        this.updateBounds();
        this.pathing.setY(yPos + this.pathingY);
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setBounds(Rectangle bounds) {
        this.bounds = bounds;
    }

    public void updateBounds() {
        this.bounds.setLocation(this.xPos, this.yPos);
    }

    public Rectangle getPathing() {
        return this.pathing;
    }

    public void setPathing(Rectangle pathing) {
        this.pathing = pathing;
    }

    public float getSpeed() {
        return this.speed;
    }

    public Image getTexture() {
        return this.texture;
    }

    public float getMaxLife() {
        return this.maxLife;
    }

    public void enforceBorders(GameContainer container) {
        if (this.xPos < 0.0f) {
            this.setxPos(0.0f);
        } else if (this.xPos + (float)this.texture.getWidth() > (float)container.getWidth()) {
            this.setxPos(container.getWidth() - this.texture.getWidth());
        }
    }

    public boolean isVisible(GameContainer container) {
        return this.yPos >= 0.0f && this.yPos < (float)(container.getHeight() - this.texture.getHeight());
    }

    public String getCurrentMoveStrat() {
        return this.currentMoveStrat;
    }

    public void setCurrentMoveStrat(String currentMoveStrat) {
        this.currentMoveStrat = currentMoveStrat;
    }

    public float getScore() {
        return this.baseScore;
    }
}

