/*
 * Decompiled with CFR 0.152.
 */
package leens_nightmare;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import leens_nightmare.LavaFlow;
import leens_nightmare.Player;
import leens_nightmare.PlayerProjectileManager;
import leens_nightmare.Projectile;
import leens_nightmare.TileManager;
import leens_nightmare.WeakFireball;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.geom.Shape;
import org.newdawn.slick.state.StateBasedGame;

public class EnemyProjectileManager {
    private Player player;
    private static ArrayList<Projectile> projectiles;
    private Iterator<Projectile> projectileIterator;
    private LavaFlow lavaFlow;

    public EnemyProjectileManager(Player player, LavaFlow lavaFlow) {
        this.player = player;
        projectiles = new ArrayList();
        this.lavaFlow = lavaFlow;
    }

    public static void SpawnProjectile(float xPos, float yPos, float angle, float angle2, int id, float difficulty) {
        try {
            switch (id) {
                case 0: {
                    projectiles.add(new WeakFireball(xPos, yPos, angle, angle2, new Image("res/WeakFireball.png"), difficulty));
                }
            }
        }
        catch (SlickException ex) {
            Logger.getLogger(PlayerProjectileManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void render(GameContainer container, StateBasedGame game, Graphics g) {
        for (Projectile p : projectiles) {
            p.render(container, game, g);
        }
    }

    public void update(GameContainer container, StateBasedGame game, int delta) {
        for (Projectile p : projectiles) {
            p.setYPos(p.getYPos() + TileManager.getScrollspeed() * (float)delta);
            p.update(container, game, delta);
            this.checkCollision(p);
            if (!(p.getYPos() < -100.0f || p.getYPos() > (float)(container.getHeight() + 100) || p.getXPos() < -100.0f || p.getXPos() > (float)(container.getWidth() + 100)) && !(p.getLifeTime() <= 0.0f)) continue;
            this.projectileIterator.remove();
        }
        this.lavaCollision();
    }

    public void checkCollision(Projectile p) {
        if (p.checkCollision((Shape)this.player.getBounds())) {
            p.collision(this.player);
        }
    }

    public void lavaCollision() {
        this.checkCollision(this.lavaFlow);
    }

    public void reset() {
        projectiles = new ArrayList();
    }
}

