/*
 * Decompiled with CFR 0.152.
 */
package leens_nightmare;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import leens_nightmare.ComparatorY;
import leens_nightmare.EnemyCreator;
import leens_nightmare.Entity;
import leens_nightmare.MathTool;
import leens_nightmare.ScoreManager;
import leens_nightmare.TileManager;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.state.StateBasedGame;

public class EnemyManager {
    private static ArrayList<Entity> enemies;
    private static Iterator<Entity> enemyiterator;
    private EnemyCreator creator;
    private ComparatorY comparatorY;
    private ScoreManager scoreManager;

    public EnemyManager(ArrayList<Entity> enemies, EnemyCreator creator, ScoreManager scoreManager) throws SlickException {
        EnemyManager.enemies = enemies;
        this.creator = creator;
        this.comparatorY = new ComparatorY();
        this.scoreManager = scoreManager;
    }

    public void spawnEnemies(int lvl, float difficulty) {
        ArrayList<Entity> list = this.creator.spawnEnemies(lvl, difficulty);
        if (list != null) {
            for (Entity e : list) {
                enemies.add(e);
            }
        }
    }

    public void render(GameContainer container, StateBasedGame game, Graphics g) {
        Collections.sort(enemies, this.comparatorY);
        for (Entity e : enemies) {
            e.render(container, game, g);
            this.drawHealthBars(e, g);
        }
    }

    public void update(GameContainer container, StateBasedGame game, int delta) {
        enemyiterator = enemies.iterator();
        while (enemyiterator.hasNext()) {
            Entity e = enemyiterator.next();
            e.setyPos(e.getyPos() + TileManager.getScrollspeed() * (float)delta);
            e.update(container, game, delta);
            if (!(e.getLife() <= 0.0f)) continue;
            this.scoreManager.addPoints(e.getScore());
            enemyiterator.remove();
        }
        for (Entity e : enemies) {
            for (Entity i : enemies) {
                e.pathing(i.getPathing());
            }
        }
    }

    public void drawHealthBars(Entity e, Graphics g) {
        g.setColor(Color.black);
        g.fillRect(e.getxPos() + 2.0f, e.getyPos() - 10.0f, (float)(e.getTexture().getWidth() - 2), 5.0f);
        g.setColor(Color.red);
        g.fillRect(e.getxPos() + 3.0f, e.getyPos() - 9.0f, (float)(e.getTexture().getWidth() - 2) * (e.getLife() / e.getMaxLife()), 3.0f);
    }

    public static void areaDamage(Entity origin, float radius, float damage) {
        for (Entity e : enemies) {
            if (!(MathTool.getDistanceBetweenEntities(origin, e) < radius) || e.equals(origin)) continue;
            e.setLife(e.getLife() - damage);
        }
    }

    public void reset(ArrayList<Entity> enemies) {
        EnemyManager.setEnemies(enemies);
    }

    public static void setEnemies(ArrayList<Entity> enemies) {
        EnemyManager.enemies = enemies;
    }
}

